#!/usr/local/bin/perl

#┌─────────────────────────────────
#│ JOYFUL NOTE
#│ joyful.cgi - 2006/10/04
#│ Copyright (c) KentWeb
#│ webmaster@kent-web.com
#└─────────────────────────────────

# 外部ファイル取り込み
require './init.cgi';
#require $jcode;
require $cgi_lib;

# 処理を定義
&parse_form;
&axscheck;
if ($mode eq "howto") { &howto; }
elsif ($mode eq "find") { &find; }
elsif ($mode eq "past" && $pastkey) { &past_log; }
elsif ($mode eq "check") { &check; }
elsif ($mode eq "lang_select") { &lang_select; }
&bbs_log;

#-------------------------------------------------
#  記事表示部
#-------------------------------------------------
sub bbs_log {
	# ページ繰越
	local($page) = 0;
	local($resfm);
	foreach ( keys(%in) ) {
		if (/^page(\d+)$/) {
			$page = $1;
		}
		if (/^res(\d+)$/) {
			$resfm = $1;
			last;
		}
	}
	# 返信フォーム押下
	if ($resfm) { &res_form; }

	# ヘッダを出力
	&header;

	# カウンタ処理
	if ($counter) { &counter; }

	# 投稿キー
	local($str_plain,$str_crypt);
	if ($regist_key) {
		require $regkeypl;

		($str_plain,$str_crypt) = &pcp_makekey;
	}

	# タイトル部
	print "<div align=\"center\">\n";
	if ($banner1 ne "<!-- 上部 -->") { print "$banner1<p>\n"; }
	if ($t_img) {
		print "<img src=\"$t_img\" width=\"$t_w\" height=\"$t_h\" alt=\"$title{$lang}\">\n";
	} else {
		print "<b style=\"font-size:$t_size;color:$t_color;\">$title{$lang}</b>\n";
	}

	# メニュー部
	print "<hr width=\"90%\">\n";
	print "[<a href=\"$homepage\" target=\"_top\">$top{$lang}</a>]\n";
	print "[<a href=\"$bbscgi?mode=howto\">$howto{$lang}</a>]\n";
	print "[<a href=\"$bbscgi?mode=find\">$find{$lang}</a>]\n";
	print "[<a href=\"$bbscgi?mode=past\">$past{$lang}</a>]\n" if ($pastkey);
	print "[<a href=\"$bbscgi?mode=lang_select\">$lang_select{$lang}</a>]\n" if ($#av_lang>0);
	print "[<a href=\"$admincgi\">$admin{$lang}</a>]\n";
	print "<hr width=\"90%\"></div>\n";

	# 投稿フォーム
	&bbs_form("normal");

	print <<EOM;
<div align="center">
<form action="$bbscgi">
<input type="hidden" name="page" value="$page">
EOM

	# 記事展開
	local($i,$top,@view,%res,%nam,$eml,%sub,%dat,%com,%col,%url,%ext,%imw,%imh);
	open(IN,"$logfile") || &error("Open Error: $logfile");
	$top = <IN>;
	while (<IN>) {
		local($no,$reno,$date,$name,$eml,$sub,$com,$url,$host,$pw,$col,$ext,$w,$h,$chk) = split(/<>/);

		++$i if (!$reno);
		next if ($i < $page + 1);
		next if ($i > $page + $pglog);

		# 親記事
		if (!$reno) {
			push(@view,$no);
		# レス記事
		} else {
			$res{$reno} .= "$no,";
		}

		# 題名の長さ
		if (length($sub) > $sub_len*2) {
			$sub = substr($sub,0,$sub_len*2) . "...";
		}
		# e-mailリンク
		if ($eml) { $name = "<a href=\"mailto:$eml\">$name</a>"; }
		# URLリンク
		if ($autolink) { &auto_link($com); }

		$nam{$no} = $name;
		$eml{$no} = $eml;
		$sub{$no} = $sub;
		$dat{$no} = $date;
		$com{$no} = $com;
		$col{$no} = $col;
		$url{$no} = $url;

		if ($ext) {
			if ($ImageCheck && $chk eq '0') {
				$ext{$no} = $IconSoon;
				$imw{$no} = $IconSoon_w;
				$imh{$no} = $IconSoon_h;
			} else {
				$ext{$no} = "$no$ext";
				$imw{$no} = $w;
				$imh{$no} = $h;
			}
		}
	}
	close(IN);

	# 表示
	foreach (@view) {
		# 親記事
		print "<p><table width=\"90%\" cellpadding=\"5\" cellspacing=\"1\" border=\"1\">\n";
		print "<tr><td bgcolor=\"$tbl_color\">\n";
		print "<b style=\"color:$subcol\">$sub{$_}</b> ";
		print "$writer{$lang} : <b>$nam{$_}</b> $date{$lang} : $dat{$_} ";
		print "<span style=\"color:$subcol\">No.$_</span> ";
		if ($url{$_}) {
			print "<a href=\"$url{$_}\" target=\"_blank\">$img_home</a> ";
		}
		print "&nbsp;&nbsp;<input type=\"submit\" name=\"res$_\" value=\"$response{$lang}\"><br>\n";
		print "<div style=\"margin-left:22px; margin-top:6px\">";

		# 画像
		if ($ext{$_} =~ /\.(jpg|gif|png)$/) {

			# 画像-左
			if ($imgpoint == 1) {
				print "<a href=\"$imgurl/$ext{$_}\" target=\"_blank\">";
				print "<img src=\"$imgurl/$ext{$_}\" width=\"$imw{$_}\" height=\"$imh{$_}\" align=\"left\" hspace=\"5\" alt=\"\" border=\"0\"></a>";
				print "<span style=\"color:$col{$_}\">$com{$_}</span><br clear=\"all\">\n";

			# 画像-下
			} elsif ($imgpoint == 2) {
				print "<span style=\"color:$col{$_}\">$com{$_}</span><br>";
				print "<a href=\"$imgurl/$ext{$_}\" target=\"_blank\">";
				print "<img src=\"$imgurl/$ext{$_}\" width=\"$imw{$_}\" height=\"$imh{$_}\" alt=\"\" border=\"0\"></a>\n";
			}

		# 画像以外
		} elsif ($ext{$_}) {
			# サイズ
			local($size) = -s "$imgdir/$ext{$_}";
			$size = int ( $size / 1024 + 0.5 ) . 'KB';

			print "<span style=\"color:$col{$_}\">$com{$_}</span><br><br>";
			print "$attach{$lang} : <a href=\"$imgurl/$ext{$_}\" target=\"_blank\">$ext{$_}</a>\n";
			print "($size)\n";

		# 添付なし
		} else {
			print "<span style=\"color:$col{$_}\">$com{$_}</span>";
		}
		print "</div>\n";

		# レス記事
		if (defined($res{$_})) {
			print "<div style=\"margin-left:22px; margin-top:5px;\"><hr size=\"1\">\n";

			foreach $res ( split(/,/, $res{$_}) ) {

				print "<b style=\"color:$subcol\">$sub{$res}</b> - <b>$nam{$res}</b> ";
				print "$dat{$res} <span style=\"color:$subcol\">No.$res</span> ";
				if ($url{$res}) {
					print "<a href=\"$url{$res}\" target=\"_blank\">$img_home</a>";
				}
				print "<br>";

				# 画像
				if ($ext{$res} =~ /\.(jpg|gif|png)$/) {

					# 画像-左
					if ($imgpoint == 1) {
						print "<a href=\"$imgurl/$ext{$res}\" target=\"_blank\">";
						print "<img src=\"$imgurl/$ext{$res}\" width=\"$imw{$res}\" height=\"$imh{$res}\" align=\"left\" hspace=\"5\" alt=\"\" border=\"0\"></a>";
						print "<span style=\"color:$col{$res}\">$com{$res}</span><br clear=\"all\">\n";

					# 画像-下
					} elsif ($imgpoint == 2) {
						print "<span style=\"color:$col{$res}\">$com{$res}</span><br>";
						print "<a href=\"$imgurl/$ext{$res}\" target=\"_blank\">";
						print "<img src=\"$imgurl/$ext{$res}\" width=\"$imw{$res}\" height=\"$imh{$res}\" alt=\"\" border=\"0\"></a>\n";
					}

				# 画像以外
				} elsif ($ext{$res}) {
					# サイズ
					local($size) = -s "$imgdir/$ext{$res}";
					$size = int ( $size / 1024 + 0.5 ) . 'KB';

					print "<span style=\"color:$col{$res}\">$com{$res}</span><br><br>";
					print "$attach{$lang} : <a href=\"$imgurl/$ext{$res}\" target=\"_blank\">$ext{$res}</a>\n";
					print "($size)\n";

				# 添付なし
				} else {
					print "<span style=\"color:$col{$res}\">$com{$res}</span>";
				}

				print "<br><br>";
			}
			print "</div>\n";
		}

		print "</td></tr></table></p>\n";
	}

	# 繰越ページ
	local($next) = $page + $pglog;
	local($back) = $page - $pglog;

	# 繰越ボタン表示
	local($pg_btn);
	if ($back >= 0) {
		local $previous=$previous{$lang};
		$previous=~s/\*/$pglog/;
		$pg_btn .= "<input type=\"submit\" name=\"page$back\" value=\"$previous\">\n";
	}
	if ($next < $i) {
		local $forward=$forward{$lang};
		$forward=~s/\*/$pglog/;
		$pg_btn .= "<input type=\"submit\" name=\"page$next\" value=\"$forward\">\n";
	}
	if ($pg_btn) {
		print "<p><table width=\"90%\"><tr><td valign=\"top\">\n";
		print $pg_btn;

		local($x,$y) = (1,0);
		while ( $i > 0 ) {
			if ($page == $y) {
				print "<b>[$x]</b>\n";
			} else {
				print "[<a href=\"$bbscgi?page$y=v\">$x</a>]\n";
			}
			$x++;
			$y = $y + $pglog;
			$i = $i - $pglog;
		}

		print "</td></tr></table></p>\n";
	}

	print <<EOM;
</form>
<form action="$registcgi" method="post">
<input type="hidden" name="page" value="$page">
$process{$lang} <select name="mode">
<option value="user_edit">$correct{$lang}
<option value="user_dele">$delete{$lang}
</select>
$m_no{$lang} <input type="text" name="no" size="3" style="ime-mode:inactive">
$m_key{$lang} <input type="password" name="pwd" size="4" maxlength="8">
<input type="submit" value="$submit{$lang}"></form>
<!-- 著作権表\示 削除不可 ($ver) -->
$banner2
<p style="font-size:10px;font-family:Verdana,Helvetica,Arial">
- <a href="http://www.kent-web.com/" target="_top">Joyful Note</a> -
<br>Edit : <a href="http://bjkoro.net/" target="_blank">BJKORO.NET</a>
</p>
</div>
EOM
	print &HtmlBot;
	exit;
}

#-------------------------------------------------
#  返信フォーム
#-------------------------------------------------
sub res_form {
	# ログ展開
	local($flg,$top,$resub,%res,%nam,$eml,%sub,%dat,%com,%col,%url);
	open(IN,"$logfile") || &error("Open Error: $logfile");
	$top = <IN>;
	while (<IN>) {
		local($no,$reno,$date,$name,$eml,$sub,$com,$url,$host,$pw,$col,$ext,$w,$h,$chk) = split(/<>/);

		if ($resfm == $no) {
			$flg = 1;

			# タイトル名
			if ($sub !~ /^Re\:/) { $resub = "Re: $sub"; }

		} elsif ($resfm == $reno) {
			$res{$reno} .= "$no,";
		} else {
			next;
		}

		$nam{$no} = $name;
		$eml{$no} = $eml;
		$sub{$no} = $sub;
		$dat{$no} = $date;
		$com{$no} = $com;
		$col{$no} = $col;
		$url{$no} = $url;
		$ext{$no} = $ext;
		$chk{$no} = $chk;
	}
	close(IN);

	if (!$flg) { &error($incor_res_req{$lang}); }

	# 投稿キー
	local($str_plain,$str_crypt);
	if ($regist_key) {
		require $regkeypl;

		($str_plain,$str_crypt) = &pcp_makekey;
	}

	# ヘッダを出力
	&header;
	print <<EOM;
<form action="$bbscgi">
<input type="submit" name="page$in{'pg'}" value="&lt; $back{$lang}">
</form>
▼<a href="#RES">$res_form{$lang}</a>
<div align="center">
EOM

	print "<p><table bgcolor=\"$log_borcol\" width=\"90%\" cellpadding=\"5\" cellspacing=\"1\">\n";
	print "<tr><td bgcolor=\"$tbl_color\">\n";
	print "<b style=\"color:$subcol\">$sub{$resfm}</b> ";
	print "$writer{$lang} : <b>$nam{$resfm}</b> $date{$lang} : $dat{$resfm} ";
	print "<span style=\"color:$subcol\">No.$resfm</span> ";
	if ($url{$resfm}) {
		print "<a href=\"$url{$resfm}\" target=\"_blank\">$img_home</a>";
	}
	print "<br>\n";
	print "<div style=\"color:$col{$resfm}; margin-left:22px; margin-top:6px\">";
	print "$com{$resfm}";
	if ($ext{$resfm}) {
		local($size) = -s "$imgdir/$resfm$ext{$resfm}";
		$size = int ( $size / 1024 ) . 'KB';

		if ($ImageCheck && $chk{$resfm} eq '0') {
			print "<br><br>$attach{$lang} : ComingSoon ($size)\n";
		} else {
			print "<br><br>$attach{$lang} : <a href=\"$imgurl/$resfm$ext{$resfm}\" target=\"_blank\">$resfm$ext{$resfm}</a> ($size)\n";
		}
	}
	print "</div>";

	# レス記事
	if (defined($res{$resfm})) {
		print "<div style=\"margin-left:22px; margin-top:5px;\">";
		foreach $res ( split(/,/, $res{$resfm}) ) {
			print "<b style=\"color:$subcol\">$sub{$res}</b> - <b>$nam{$res}</b> ";
			print "$dat{$res} <span style=\"color:$subcol\">No.$res</span> ";
			if ($url{$res}) {
				print "<a href=\"$url{$res}\" target=\"_blank\">$img_home</a>";
			}
			print "<br><span style=\"color:$col{$res}\">$com{$res}</span><br><br>";
		}
		print "</div>\n";
	}

	print "</td></tr></table></p></div>\n";
	print "<a name=\"RES\"></a>\n";

	$sub = $resub;
	&bbs_form("res", "res");

	print &HtmlBot;
	exit;
}

#-------------------------------------------------
#  留意事項
#-------------------------------------------------
sub howto {
	if ($in_email) {
		$eml_msg = $eml_msg_1{$lang};
	} else {
		$eml_msg = $eml_msg_2{$lang};
	}

	local($maxkb) = int ($maxdata / 1024) . 'KB';
	if ($gif) { $FILE .= "GIF, "; }
	if ($jpeg) { $FILE .= "JPEG, "; }
	if ($png) { $FILE .= "PNG, "; }
	if ($text) { $FILE .= "TEXT, "; }
	if ($lha) { $FILE .= "LHA, "; }
	if ($zip) { $FILE .= "ZIP, "; }
	if ($pdf) { $FILE .= "PDF, "; }
	if ($midi) { $FILE .= "MIDI, "; }
	if ($word) { $FILE .= "WORD, "; }
	if ($excel) { $FILE .= "EXCEL, "; }
	if ($ppt) { $FILE .= "POWERPOINT, "; }
	if ($rm) { $FILE .= "RM, "; }
	if ($ram) { $FILE .= "RAM, "; }
	if ($mpeg) { $FILE .= "MPEG, "; }
	if ($mp3) { $FILE .= "MP3, "; }
	$FILE =~ s/\, $//;

	$howto_all{$lang}=~s/\{FILE\}/$FILE/;
	$howto_all{$lang}=~s/\{maxkb\}/$maxkb/;
	$howto_all{$lang}=~s/\{eml_msg\}/$eml_msg/;

	&header;
	print <<EOM;
<div align="center">
<h3>$howto{$lang}</h3>
<table width="90%" border="1" cellpadding="10">
<tr><td bgcolor="$tbl_color">
<ol>
$howto_all{$lang}
</ol>
</td></tr></table>
<p>
<form>
<input type="button" value="$back{$lang}" onclick="history.back()">
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-------------------------------------------------
#  ワード検索処理
#-------------------------------------------------
sub find {
	# ページ数
	local($page) = 0;
	foreach ( keys(%in) ) {
		if (/^page(\d+)$/) {
			$page = $1;
			last;
		}
	}

	&header;
	print <<EOM;
<form action="$bbscgi">
<input type="submit" value="$back{$lang}">
</form>
<ul>
$find_howto{$lang}
</ul>
<table>
<tr>
EOM

	&search($logfile);

	print &HtmlBot;
	exit;
}

#-------------------------------------------------
#  検索処理
#-------------------------------------------------
sub search {
	local($target) = @_;
	local($i, $flag, $next, $back, $enwd, $wd, @wd);

	print "<td><form action=\"$bbscgi\" method=\"post\">\n";
	print "<input type=\"hidden\" name=\"mode\" value=\"$mode\">\n";

	local($para);
	if ($mode eq "past") {
		print "<input type=\"hidden\" name=\"pastlog\" value=\"$in{'pastlog'}\">\n";
		$para .= "&pastlog=$in{'pastlog'}";
	}

	print "$keyword{$lang} <input type=\"text\" name=\"word\" size=\"40\" value=\"$in{'word'}\"> ";
	print "$condition{$lang} <select name=\"cond\"> &nbsp; ";

	if ($in{'cond'} eq "") { $in{'cond'} = "AND"; }
	foreach ("AND", "OR") {
		if ($in{'cond'} eq $_) {
			print "<option value=\"$_\" selected>$_\n";
		} else {
			print "<option value=\"$_\">$_\n";
		}
	}
	print "</select> $display{$lang} <select name=\"view\">\n";
	if ($in{'view'} eq "") { $in{'view'} = 10; }
	foreach (10,15,20,25,30) {
		local $view=$view{$lang};
		$view=~s/\*/$_/;
		if ($in{'view'} == $_) {
			print "<option value=\"$_\" selected>$view\n";
		} else {
			print "<option value=\"$_\">$view\n";
		}
	}
	print "</select> <input type=\"submit\" value=\" $search{$lang} \">";
	print "</td></form></tr></table>\n";

	# ワード検索の実行と結果表示
	if ($in{'word'} ne "") {

		# 入力内容を整理
		$in{'word'} =~ s/　/ /g;
		local(@wd) = split(/\s+/, $in{'word'});

		# ファイルを読み込み
		print "<dl>\n";
		local($i) = 0;
		open(IN,"$target") || &error("Open Error: $target");
		while (<IN>) {
			local($no,$reno,$date,$nam,$eml,$sub,$com,$url,$host,$pw,$col,$ext,$w,$h,$chk) = split(/<>/);
			local($flag);
			foreach $wd (@wd) {
				if ("$nam $eml $sub $com $url"=~/$wd/ig) {
				#if (index("$nam $eml $sub $com $url",$wd) >= 0) {
					$flag = 1;
					if ($in{'cond'} eq 'OR') { last; }
				} else {
					if ($in{'cond'} eq 'AND') { $flag = 0; last; }
				}
			}
			if ($flag) {
				$i++;
				if ($i < $page + 1) { next; }
				if ($i > $page + $in{'view'}) { next; }

				if ($eml) { $nam = "<a href=\"mailto:$eml\">$nam</a>"; }
				if ($url) { $com .= "<p><a href=\"$url\" target=\"_blank\">$url</a>"; }

				print "<dt><hr>[<b>$no</b>] <b style=\"color:$subcol\">$sub</b> ";
				print "$writer{$lang} : <b>$nam</b> $date{$lang} : $date<br><br>\n";
				print "<dd><div style=\"color:$col\">$com</div>\n";
				if ($ext) {
					local($size) = -s "$imgdir/$no$ext";
					$size = int ( $size / 1024 ) . 'KB';

					if ($ImageCheck && $chk eq '0') {
						print "<br><br><dd>$attach{$lang} : ComingSoon ($size)\n";
					} else {
						print "<br><br><dd>$attach{$lang} : <a href=\"$imgurl/$no$ext\" target=\"_blank\">$no$ext</a> ($size)\n";
					}
				}
			}
		}
		close(IN);
		$s_result{$lang}=~s/\*/$i/;
		print "<dt><hr>$s_result{$lang}</dl>\n";

		local($next) = $page + $in{'view'};
		local($back) = $page - $in{'view'};
		local($enwd) = &url_enc($in{'word'});
		if ($back >= 0) {
			$previous{$lang}=~s/\*/$in{'view'}/;
			print "[<a href=\"$bbscgi?mode=$mode&page$back=v&word=$enwd&view=$in{'view'}&cond=$in{'cond'}$para\">$previous{$lang}</a>]\n";
		}
		if ($next < $i) {
			$forward{$lang}=~s/\*/$in{'view'}/;
			print "[<a href=\"$bbscgi?mode=$mode&page$next=v&word=$enwd&view=$in{'view'}&cond=$in{'cond'}$para\">$forward{$lang}</a>]\n";
		}
		print "</body></html>\n";
		exit;
	}
}

#-------------------------------------------------
#  カウンタ処理
#-------------------------------------------------
sub counter {
	local($count, $cntup, @count);

	# 閲覧時のみカウントアップ
	if ($mode eq '') { $cntup = 1; } else { $cntup = 0; }

	# カウントファイルを読みこみ
	open(LOG,"+< $cntfile") || &error("Open Error: $cntfile");
	eval "flock(LOG, 2);";
	$count = <LOG>;

	# IPチェックとログ破損チェック
	local($cnt, $ip) = split(/:/, $count);
	if ($addr eq $ip || $cnt eq "") { $cntup = 0; }

	# カウントアップ
	if ($cntup) {
		$cnt++;
		seek(LOG, 0, 0);
		print LOG "$cnt:$addr";
		truncate(LOG, tell(LOG));
	}
	close(LOG);

	# 桁数調整
	while(length($cnt) < $mini_fig) { $cnt = '0' . $cnt; }
	local(@cnts) = split(//, $cnt);

	# GIFカウンタ表示
	if ($counter == 2) {
		foreach (0 .. $#cnts) {
			print "<img src=\"$gif_path/$cnts[$_]\.gif\" alt=\"$cnts[$_]\" width=\"$mini_w\" height=\"$mini_h\">";
		}

	# テキストカウンタ表示
	} else {
		print "<font color=\"$cnt_color\" face=\"verdana,Times New Roman,Arial\">$cnt</font><br>\n";
	}
}

#-------------------------------------------------
#  自動URLリンク
#-------------------------------------------------
sub auto_link {
	$_[0] =~ s/([^=^\"]|^)(http\:[\w\.\~\-\/\?\&\+\=\:\@\%\;\#\%]+)/$1<a href=\"$2\" target=\"_blank\">$2<\/a>/g;
}

#-------------------------------------------------
#  過去ログ
#-------------------------------------------------
sub past_log {
	# ページ数
	local($page) = 0;
	foreach ( keys(%in) ) {
		if (/^page(\d+)$/) {
			$page = $1;
			last;
		}
	}

	# 過去ログNo
	open(IN,"$nofile") || &error("Open Error: $nofile");
	local($no) = <IN>;
	close(IN);

	$in{'pastlog'} =~ s/\D//g;
	if (!$in{'pastlog'}) { $in{'pastlog'} = $no; }

	&header;
	print <<"EOM";
<form action="$bbscgi" method="post">
<input type="submit" value="&lt; $back{$lang}">
</form>
<form action="$bbscgi" method="post">
<input type="hidden" name="mode" value="past">
<table><tr><td><b>$past{$lang} : </b> <select name="pastlog">
EOM

	# 過去ログ選択
	for ( $i = $no; $i > 0; --$i ) {
		$i = sprintf("%04d", $i);
		next unless (-e "$pastdir/$i.cgi");
		if ($in{'pastlog'} == $i) {
			print "<option value=\"$i\" selected>$i\n";
		} else {
			print "<option value=\"$i\">$i\n";
		}
	}
	print "</select> <input type=\"submit\" value=\"$move{$lang}\">";
	print "</td></form><td width=\"20\"></td>\n";

	local($file) = sprintf("%s/%04d.cgi", $pastdir,$in{'pastlog'});
	&search($file);

	print "<dl>\n";
	local($i) = 0;
	open(IN,"$file") || &error("Open Error: $file");
	while (<IN>) {
		local($no,$reno,$date,$nam,$eml,$sub,$com,$url,$host,$pw,$col,$ext,$w,$h,$chk) = split(/<>/);
		if (!$reno) { $i++; }
		if ($i < $page + 1) { next; }
		if ($i > $page + $pglog) { last; }

		&auto_link($com) if ($link);

		if ($eml) { $nam = "<a href=\"mailto:$eml\">$nam</a>"; }
		if ($url) { $url = "&lt;<a href=\"$url\" target=\"_blank\">URL</a>&gt;"; }

		print "<dt><hr>[<b>$no</b>] <b style=\"color:$subcol\">$sub</b> ";
		print "$writer{$lang} : <b>$nam</b> $date{$lang} : $date &nbsp; $url <br><br>";
		print "<dd>$com<br><br>\n";

	}
	close(IN);

	print "<dt><hr></dl>\n";

	# ページ繰越
	local($next) = $page + $pglog;
	local($back) = $page - $pglog;

	if ($back >= 0 || $next < $i) {
		print "<form action=\"$bbscgi\" method=\"post\">\n";
		print "<input type=\"hidden\" name=\"mode\" value=\"past\">\n";
		print "<input type=\"hidden\" name=\"pastlog\" value=\"$in{'pastlog'}\">\n";

		if ($back >= 0) {
			$previous{$lang}=~s/\*/$pglog/;
			print "<input type=\"submit\" name=\"page$back\" value=\"$previous{$lang}\">\n";
		}
		if ($next < $i) {
			$forward{$lang}=~s/\*/$pglog/;
			print "<input type=\"submit\" name=\"page$next\" value=\"$forward{$lang}\">\n";
		}

		print "</form>\n";
	}
	print &HtmlBot;
	exit;
}

#-------------------------------------------------
#  チェックモード
#-------------------------------------------------
sub check {
	&header;
	print "<h2>Check Mode</h2>\n";
	print "<ul>\n";

	local $path=$path{$lang};
	local $permission=$permission{$lang};

	# ログパス
	$path=~s/\*/$logfile{$lang}/;
	$permission=~s/\*/$logfile{$lang}/;
	if (-e $logfile) {
		print "<li>$path : OK\n";
		# パーミッション
		if (-r $logfile && -w $logfile) {
			print "<li>$permission : OK\n";
		} else { print "<li>$permission : NG\n"; }
	} else { print "<li>$path : NG &gt;&gt; $logfile\n"; }

	local $path=$path{$lang};
	local $permission=$permission{$lang};

	# カウンタログ
	$path=~s/\*/$counter_file{$lang}/;
	$permission=~s/\*/$counter_file{$lang}/;
	print "<li>$counter{$lang} : ";
	if ($counter) {
		print "$set{$lang}\n";
		if (-e $cntfile) { print "<li>$path : OK\n"; }
		else { print "<li>$path : NG &gt;&gt; $cntfile\n"; }
	} else { print "$noset{$lang}\n"; }

	local $path=$path{$lang};
	local $permission=$permission{$lang};

	# 画像ディレクトリ
	$path=~s/\*/$imgdir{$lang}/;
	$permission=~s/\*/$imgdir{$lang}/;
	print "<li>$imgdir{$lang} : $imgdir\n";
	if (-d $imgdir) {
		print "<li>$path : OK\n";
		if (-r $imgdir && -w $imgdir && -x $imgdir) {
			print "<li>$permission : OK\n";
		} else {
			print "<li>$permission : NG &gt;&gt; $imgdir\n";
		}
	} else { print "<li>$imgdir{$lang} NG &gt;&gt; $imgdir\n"; }

	# 過去ログ
	print "<li>$past{$lang} : ";
	if ($pastkey == 0) { print "$noset{$lang}\n"; }
	else {
		print "$set{$lang}\n";

		local $path=$path{$lang};
		local $permission=$permission{$lang};
		$path=~s/\*/$nofile{$lang}/;
		$permission=~s/\*/$nofile{$lang}/;

		# NOファイル
		if (-e $nofile) {
			print "<li>$path : OK\n";
			if (-r $nofile && -w $nofile) {
				print "<li>$permission : OK\n";
			} else { print "<li>$permission : NG &gt;&gt; $nofile\n"; }
		} else { print "<li>$path : NG &gt;&gt; $nofile\n"; }

		local $path=$path{$lang};
		local $permission=$permission{$lang};
		$path=~s/\*/$pastdir{$lang}/;
		$permission=~s/\*/$pastdir{$lang}/;

		# ディレクトリ
		if (-d $pastdir) {
			print "<li>$path : OK\n";
			if (-r $pastdir && -w $pastdir && -x $pastdir) {
				print "<li>$permission : OK\n";
			} else {
				print "<li>$permission : NG &gt;&gt; $pastdir\n";
			}
		} else { print "<li>$path : NG &gt;&gt; $pastdir\n"; }
	}
	print "</ul>\n</body></html>\n";
	exit;
}

#-------------------------------------------------
#  URLエンコード
#-------------------------------------------------
sub url_enc {
	local($_) = @_;

	s/(\W)/'%' . unpack('H2', $1)/eg;
	s/\s/+/g;
	$_;
}

