#┌─────────────────────────────────
#│  JOYFUL NOTE v2.67 (2006/10/08)
#│  Copyright (c) KentWeb
#│  webmaster@kent-web.com
#│  http://www.kent-web.com/
#└─────────────────────────────────
$ver = 'JoyfulNote v2.67';
#┌─────────────────────────────────
#│ [注意事項]
#│ 1. このスクリプトはフリーソフトです。このスクリプトを使用した
#│    いかなる損害に対して作者は一切の責任を負いません。
#│ 2. 設置に関する質問はサポート掲示板にお願いいたします。
#│    直接メールによる質問は一切お受けいたしておりません。
#│ 3. このスクリプトは、method=POST 専用です。	
#│ 4. 同梱のアイコンで、以下のファイルの著作権者は以下のとおりです。
#│    home.gif : mayuRinさん
#│    clip.gif : 牛飼いとアイコンの部屋さん
#└─────────────────────────────────
#
# 【ファイル構成例】
#
#  public_html (ホームディレクトリ)
#      |
#      +-- joyful / joyful.cgi    [705]
#            |      admin.cgi     [705]
#            |      regist.cgi    [705]
#            |      registkey.cgi [705]
#            |
#            +-- lib / cgi-lib.pl
#            |         registkey.pl
#            |
#            +-- data / joylog.cgi [606]
#            |          count.dat  [606]
#            |          pastno.dat [606]
#            |
#            +-- past [707] / 0001.cgi [606] ...
#            |
#            +-- img  [707] / home.gif, bear.gif, ...

#-------------------------------------------------
#  設定項目
#-------------------------------------------------
# ライブラリ
#$jcode    = './lib/jcode.pl';
$cgi_lib  = './lib/cgi-lib.pl';
$regkeypl = './lib/registkey.pl';

# カウンタファイル
$cntfile = './data/count.dat';

# 本体CGIのURL【URLパス】
$bbscgi = './uni_joyful.cgi';

# 書込CGIのURL【URLパス】
$registcgi = './regist.cgi';

# 管理CGIのURL【URLパス】
$admincgi = './admin.cgi';

# ログファイル【サーバパス】
$logfile = './data/joylog.cgi';

# アップロードディレクトリ【サーバパス】
# → パスの最後に / をつけない
$imgdir = './img';

# アップロードディレクトリ【URLパス】
# → パスの最後に / をつけない
$imgurl = "./img";

# 投稿キー画像生成ファイル【URLパス】
$registkeycgi = './registkey.cgi';

# 過去ログ用NOファイル【サーバパス】
$nofile  = './data/pastno.dat';

# 過去ログのディレクトリ【サーバパス】
# → パスの最後に / をつけない
$pastdir = './past';
#-------------------------------------------------
#  設定完了
#-------------------------------------------------
$setup='./setup.pl';
require $setup;
%lang_set=(
	'jp'=>'./lang/jp.pl',
	'en'=>'./lang/en.pl',
	'tc'=>'./lang/tc.pl',
	'sc'=>'./lang/sc.pl'
);
foreach $l(keys %lang_set){
	if(-e $lang_set{$l}){push(@lang,$l);}
}
if(@lang==()){exit;}
foreach(@av_lang){
	if(index(join(",",@lang), $_)==-1){next;}
	push(@AV_LANG,$_);
}
@av_lang=@AV_LANG;
#====  LANGUAGE SELECTOR  ====
sub lang_select{
	&header;
	print <<EOM;
<div align="center">
<table width="95%"><tr><td align=right nowrap>
<a href="$bbscgi?">$top{$lang}</a> &gt; $lang_select{$lang}
</td></tr></table>
<center>
<form action="$bbscgi" method=post>
<input type=hidden name=act value="lang_select">
EOM
	foreach(@av_lang){
		print "<input type=radio name=lang value=\"$_\"";
		if($_ eq "$lang"){print " checked";}
		print ">$lang_name{$_}{$lang}\n";
	}
	print <<EOM;
<input type=submit value=" $select{$lang} ">
</form>
</center>
</body></html>
EOM
	exit;
}
#======デフォルト言語検出======#
sub lang{
	local @LANG=split(/,/,$ENV{'HTTP_ACCEPT_LANGUAGE'});
	local $lang;
	for(@LANG){
		$flag=0;
		foreach $l(@av_lang){
			$lang=$l;
			foreach $c(@{$lang_code{$l}}){
				if($c eq "$_"){$flag=1;last;}
			}
			if($flag==1){last;}
		}
		if($flag==1){return $lang;}
	}
	if(index(join(",",@av_lang),$def_lang)>=0){return $def_lang;}else{return $lang[0];}
}
#====  GET SAVED LANG  ====
sub get_saved_lang{
	local @cookie=split(/;/,$ENV{'HTTP_COOKIE'});
	foreach $cookie(@cookie){
		local($name,$value)=split(/=/,$cookie);
		$name=~s/\s//g;
		$DUMMY{$name}=$value;
	}
	local @cookie=split(/<>/,$DUMMY{'UNI_JOYFUL'});
	foreach $cookie(@cookie){
		local($name,$value)=split(/:/,$cookie);
		$COOKIE{$name}=$value;
	}
	return ($COOKIE{'lang'});
}
#====  SAVE LANG  ====
sub save_lang{
	local($slang)=@_;
	local ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst)=gmtime(time+60*24*60*60);
	local @week=("Sun","Mon","Tue","Wed","Thu","Fri","Sat");
	local @mon=("Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec");
	$expires=sprintf("%s,%02d\-%s\-%04d %02d\:%02d\:%02dGMT",$week[$wday],$mday,$mon[$mon],$year+1900,$hour,$min,$sec);
	$cook="lang\:$lang";
	print "Set-Cookie:UNI_JOYFUL=$cook;expires=$expires\n";
}
#-------------------------------------------------
#  アクセス制限
#-------------------------------------------------
sub axscheck {
	# IP&ホスト取得
	$host = $ENV{'REMOTE_HOST'};
	$addr = $ENV{'REMOTE_ADDR'};

	if ($gethostbyaddr && ($host eq "" || $host eq $addr)) {
		$host = gethostbyaddr(pack("C4", split(/\./, $addr)), 2);
	}

	# IPチェック
	local($flg);
	foreach ( split(/\s+/, $deny_addr) ) {
		s/\./\\\./g;
		s/\*/\.\*/g;

		if ($addr =~ /^$_/i) { $flg = 1; last; }
	}
	if ($flg) {
		&error($not_allow{$lang});

	# ホストチェック
	} elsif ($host) {

		foreach ( split(/\s+/, $deny_host) ) {
			s/\./\\\./g;
			s/\*/\.\*/g;

			if ($host =~ /$_$/i) { $flg = 1; last; }
		}
		if ($flg) {
			&error($not_allow{$lang});
		}
	}
	if ($host eq "") { $host = $addr; }
}

#-------------------------------------------------
#  フォームデコード
#-------------------------------------------------
sub parse_form {
	undef(%in);
	&ReadParse;
	while ( local($key, $val) = each(%in) ) {

		next if ($key eq "upfile");

		# シフトJISコード変換
		#&jcode'convert(*val, "sjis", "", "z");

		# タグ処理
		$val =~ s/&/&amp;/g;
		$val =~ s/"/&quot;/g;
		$val =~ s/</&lt;/g;
		$val =~ s/>/&gt;/g;

		# 改行処理
		$val =~ s/\r\n/<br>/g;
		$val =~ s/\r/<br>/g;
		$val =~ s/\n/<br>/g;

		$in{$key} = $val;
	}
	$mode = $in{'mode'};

	if($in{'act'} eq "lang_select"){
		$lang=$in{'lang'};
		&save_lang($lang);
	}else{
		$lang=&get_saved_lang;
		local $flag=0;
		if($lang){
			foreach(@av_lang){
				if($_ eq "$lang"){$flag=1;last;}
			}
			if($flag==0){undef($lang);}
		}
	}
	unless($lang){$lang=&lang;}
	require $lang_set{$lang};
}

#-------------------------------------------------
#  エラー処理
#-------------------------------------------------
sub error {
	&header if (!$headflag);
	print <<EOM;
<div align="center">
<hr width="400">
<h3>ERROR !</h3>
<font color="red">$_[0]</font>
<p>
<hr width="400">
</div>
EOM
	print &HtmlBot;
	exit;
}

#-------------------------------------------------
#  HTMLヘッダー
#-------------------------------------------------
sub header {
	$headflag=1;
	print "Content-type: text/html\n\n";
	print <<"EOM";
<html>
<head>
<META HTTP-EQUIV="Content-type" CONTENT="text/html; charset=utf-8">
<style type="text/css">
<!--
body,td,th { font-size:$b_size; font-family:$face{$lang} }
a:hover { color: $al }
-->
</style>
<title>$title{$lang}</title>
</head>
EOM

	if ($bg) {
		print "<body background=\"$bg\" bgcolor=\"$bc\" text=\"$tx\" link=\"$lk\" vlink=\"$vl\" alink=\"$al\">\n";
	} else {
		print "<body bgcolor=\"$bc\" text=\"$tx\" link=\"$lk\" vlink=\"$vl\" alink=\"$al\">\n";
	}
}

#-------------------------------------------------
#  クッキー発行
#-------------------------------------------------
sub set_cookie {
	local(@cook) = @_;
	local($gmt, $cook, @t, @m, @w);

	@t = gmtime(time + 60*24*60*60);
	@m = ('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec');
	@w = ('Sun','Mon','Tue','Wed','Thu','Fri','Sat');

	# 国際標準時を定義
	$gmt = sprintf("%s, %02d-%s-%04d %02d:%02d:%02d GMT",
			$w[$t[6]], $t[3], $m[$t[4]], $t[5]+1900, $t[2], $t[1], $t[0]);

	# 保存データをURLエンコード
	foreach (@cook) {
		s/(\W)/sprintf("%%%02X", unpack("C", $1))/eg;
		$cook .= "$_<>";
	}

	# 格納
	print "Set-Cookie: JoyfulNote=$cook; expires=$gmt\n";
}

#-------------------------------------------------
#  クッキー取得
#-------------------------------------------------
sub get_cookie {
	local($key, $val, *cook);

	# クッキーを取得
	$cook = $ENV{'HTTP_COOKIE'};

	# 該当IDを取り出す
	foreach ( split(/;/, $cook) ) {
		($key, $val) = split(/=/);
		$key =~ s/\s//g;
		$cook{$key} = $val;
	}

	# データをURLデコードして復元
	foreach ( split(/<>/, $cook{'JoyfulNote'}) ) {
		s/%([0-9A-Fa-f][0-9A-Fa-f])/pack("C", hex($1))/eg;

		push(@cook,$_);
	}
	return @cook;
}

#-------------------------------------------------
#  投稿フォーム
#-------------------------------------------------
sub bbs_form {
	local($type, $resmd) = @_;
	local($cnam,$ceml,$curl,$cpwd,$cico,$ccol);

	print <<EOM;
<blockquote>
<form action="$registcgi" method="post" enctype="multipart/form-data">
EOM

	## フォーム種別を判別
	# 修正
	if ($type eq "edit" || $type eq "admin") {

		if ($type eq "edit") {
			print "<input type=\"hidden\" name=\"pwd\" value=\"$in{'pwd'}\">\n";
			print "<input type=\"hidden\" name=\"mode\" value=\"user_edit\">\n";
			print "<input type=\"hidden\" name=\"job\" value=\"edit\">\n";
		} else {
			print "<input type=\"hidden\" name=\"mode\" value=\"admin\">\n";
			print "<input type=\"hidden\" name=\"pass\" value=\"$in{'pass'}\">\n";
			print "<input type=\"hidden\" name=\"job\" value=\"edit2\">\n";
		}

		print "<input type=\"hidden\" name=\"no\" value=\"$in{'no'}\">\n";

		$cnam = $name;
		$ceml = $eml;
		$curl = $url;
		$ccol = $col;
	# 返信
	} elsif ($resmd) {
		print "<input type=\"hidden\" name=\"mode\" value=\"regist\">\n";
		print "<input type=\"hidden\" name=\"reno\" value=\"$resfm\">\n";

		($cnam,$ceml,$curl,$cpwd,$cico,$ccol) = &get_cookie;
	# 新規
	} else {
		print "<input type=\"hidden\" name=\"mode\" value=\"regist\">\n";

		($cnam,$ceml,$curl,$cpwd,$cico,$ccol) = &get_cookie;
	}
	if (!$curl) { $curl = 'http://'; }

	print <<EOM;
<table border="0" cellspacing="0">
<tr>
  <td nowrap><b>$name{$lang}</b></td>
  <td><input type="text" name="name" size="28" value="$cnam"></td>
</tr>
<tr>
  <td nowrap><b>$email{$lang}</b></td>
  <td><input type="text" name="email" size="28" value="$ceml"></td>
</tr>
<tr>
  <td nowrap><b>$subject{$lang}</b></td>
  <td nowrap>
    <input type="text" name="sub" size="36" value="$sub">
<input type="submit" value="$contribute{$lang}"><input type="reset" value="$reset{$lang}">
  </td>
</tr>
<tr>
  <td colspan="2">
    <b>$comment{$lang}</b><br>
    <textarea cols="56" rows="7" name="comment">$com</textarea>
  </td>
</tr>
<tr>
  <td nowrap><b>$url{$lang}</b></td>
  <td><input type="text" size="50" name="url" value="$curl"></td>
</tr>
EOM

	# 添付フォーム
	unless ($resmd && !$res_clip) {
		print "<tr><td><b>$attach{$lang}</b></td>\n";
		print "<td><input type=\"file\" name=\"upfile\" size=\"40\">\n";

		# 添付
		if ($ext) {
			print "&nbsp;[<a href=\"$imgurl/$in{'no'}$ext\" target=\"_blank\">$attach{$lang}</a>]\n";
			print "<input type=\"checkbox\" name=\"imgdel\" value=\"1\">$delete{$lang}\n";
		}

		print "</td></tr>\n";
	}
	# パスワード欄
	if ($type ne "edit" && $type ne "admin") {
		print "<tr><td nowrap><b>$m_key{$lang}</b></td>";
		print "<td><input type=\"password\" name=\"pwd\" size=\"8\" maxlength=\"8\" value=\"$cpwd\">\n";
		print "($m_key_info{$lang})</td></tr>\n";
	}
	# 投稿キー
	if ($regist_key && ($type eq "normal" || $type eq "res")) {
		$rand_key_info{$lang}=~s/\*/<img src=\"$registkeycgi?$str_crypt\" align=\"absmiddle\" alt=\"$rand_key{$lang}\">/;
		print "<tr><td nowrap><b>$rand_key{$lang}</b></td>";
		print "<td><input type=\"text\" name=\"regikey\" size=\"6\" style=\"ime-mode:inactive\" value=\"\">\n";
		print "($rand_key_info{$lang})</td></tr>\n";
		print "<input type=\"hidden\" name=\"str_crypt\" value=\"$str_crypt\">\n";
	}

	# 色指定
	print "<tr><td nowrap><b>$fontcolor{$lang}</b></td><td>\n";
	@col = split(/\s+/, $colors);
	if ($ccol eq "") { $ccol = $col[0]; }
	foreach (@col) {
		if ($ccol eq $_) {
			print "<input type=\"radio\" name=\"color\" value=\"$_\" checked><font color=\"$_\">$font_samp{$lang}</font>\n";
		} else {
			print "<input type=\"radio\" name=\"color\" value=\"$_\"><font color=\"$_\">$font_samp{$lang}</font>\n";
		}
	}
	print "</td></tr></table></form>\n";
	if ($ImageCheck) {
		print "$imgcheck{$lang}<br>\n";
	}
	print "</blockquote>\n";
}




1;

